# Hybrid WhatsApp Gateway SaaS Platform

A multi-tenant SaaS WhatsApp Gateway supporting Meta Cloud API and Baileys (headless) with API-Key & Webhook first architecture.

## Architecture

```
Client App / CRM / ERP
        ↓
Hybrid WhatsApp Gateway API (PHP)
        ↓
Gateway Service (Node.js)
        ↓
Meta Cloud API  |  Baileys Engine
```

## Tech Stack

- **Backend**: PHP 8.x with MySQL
- **Gateway Service**: Node.js with Express
- **Frontend**: Vue 3 + Tailwind CSS
- **WhatsApp**: Meta Cloud API + Baileys

## Project Structure

```
whatsapp_api/
├── backend/                 # PHP Backend
│   ├── app/
│   │   ├── Controllers/    # API Controllers
│   │   ├── Models/         # Database models
│   │   ├── Middleware/     # Auth & API middleware
│   │   ├── Services/       # Business logic
│   │   └── Utils/          # Helper functions
│   ├── config/             # Configuration files
│   ├── routes/             # API routes
│   └── public/             # Entry point
├── gateway/                 # Node.js Gateway Service
│   ├── src/
│   │   ├── services/       # Meta & Baileys services
│   │   ├── routes/         # API routes
│   │   ├── utils/          # Helpers
│   │   └── index.js        # Entry point
│   └── sessions/           # Baileys auth sessions
├── frontend/               # Vue.js Frontend
│   ├── src/
│   │   ├── views/          # Pages
│   │   ├── components/     # Reusable components
│   │   ├── stores/         # Pinia stores
│   │   ├── router/         # Vue Router
│   │   └── api/            # API client
│   └── public/
├── database/               # SQL schemas
└── docs/                   # Documentation
```

## Quick Start

### 1. Database Setup

```bash
# Create database and import schema
mysql -u root -p
CREATE DATABASE whatsapp_gateway;
exit;
mysql -u root -p whatsapp_gateway < database/schema.sql
```

### 2. Backend Setup

```bash
cd backend
composer install
cp .env.example .env
# Edit .env with your database credentials
```

### 3. Gateway Setup

```bash
cd gateway
npm install
cp .env.example .env
# Edit .env with your settings
npm start
```

### 4. Frontend Setup

```bash
cd frontend
npm install
npm run dev
```

## Default Admin Login

- **Email**: admin@example.com
- **Password**: admin123

> ⚠️ Change the default password after first login!

## API Authentication

All API requests require:
```
X-API-KEY: your_api_key
X-API-SECRET: your_api_secret
```

### Send a Message

```bash
curl -X POST http://your-domain.com/api/send-message \
  -H "Content-Type: application/json" \
  -H "X-API-KEY: your_api_key" \
  -H "X-API-SECRET: your_api_secret" \
  -d '{"to": "+923124356789", "message": "Hello!", "type": "text"}'
```

## Features

### Core Features
- ✅ Multi-tenant architecture
- ✅ Meta Cloud API integration
- ✅ Baileys (headless) integration
- ✅ Unified webhook system
- ✅ QR code authentication for Baileys
- ✅ Automatic session management

### User Features
- ✅ Email/Password & Google OAuth authentication
- ✅ Multiple WhatsApp numbers per account
- ✅ Project-based API key management
- ✅ Webhook configuration per project
- ✅ Message history & export
- ✅ Usage statistics

### Admin Features
- ✅ User management (suspend/ban/activate)
- ✅ Package management
- ✅ Route configuration (Meta/Baileys)
- ✅ System analytics dashboard
- ✅ Audit logs

### Billing Features
- ✅ Subscription packages
- ✅ Message quotas
- ✅ Usage tracking
- ✅ Credit system

## Documentation

- [API Documentation](docs/API.md)
- [Deployment Guide](docs/DEPLOYMENT.md)
- [Admin Manual](docs/ADMIN_MANUAL.md)
- [Client Guide](docs/CLIENT_GUIDE.md)

## Environment Variables

### Backend (.env)
```env
DB_HOST=localhost
DB_DATABASE=whatsapp_gateway
DB_USERNAME=root
DB_PASSWORD=
JWT_SECRET=your-secret-key
GATEWAY_URL=http://localhost:3000
GATEWAY_SECRET=your-gateway-secret
```

### Gateway (.env)
```env
PORT=3000
GATEWAY_SECRET=your-gateway-secret
BACKEND_URL=http://localhost/api
DB_HOST=localhost
DB_NAME=whatsapp_gateway
```

## Production Deployment

For production deployment, use PM2 for the Gateway service:

```bash
cd gateway
npm install -g pm2
pm2 start ecosystem.config.js
pm2 save
```

See [Deployment Guide](docs/DEPLOYMENT.md) for full instructions.

## License

Proprietary - All rights reserved
