<?php

namespace App\Models;

class Package extends BaseModel
{
    protected string $table = 'packages';
    
    protected array $fillable = [
        'name', 'slug', 'description', 'price_monthly', 'price_yearly',
        'messages_limit', 'whatsapp_numbers_limit', 'projects_per_number_limit',
        'api_rate_limit', 'meta_enabled', 'baileys_enabled', 'webhook_retries',
        'message_retention_days', 'support_level', 'features', 'is_active',
        'is_default', 'sort_order'
    ];
    
    public function getActivePackages(): array
    {
        $stmt = $this->db->prepare(
            "SELECT * FROM {$this->table} WHERE is_active = 1 ORDER BY sort_order ASC"
        );
        $stmt->execute();
        return $stmt->fetchAll();
    }
    
    public function getDefaultPackage(): ?array
    {
        return $this->findBy('is_default', 1);
    }
    
    public function findBySlug(string $slug): ?array
    {
        return $this->findBy('slug', $slug);
    }
    
    public function setDefault(int $packageId): bool
    {
        $this->execute("UPDATE {$this->table} SET is_default = 0");
        return $this->update($packageId, ['is_default' => 1]);
    }
    
    public function getPackageStats(int $packageId): array
    {
        $stmt = $this->db->prepare(
            "SELECT COUNT(DISTINCT s.user_id) as subscribers,
                    SUM(s.messages_used) as total_messages_used
             FROM subscriptions s
             WHERE s.package_id = ? AND s.status = 'active'"
        );
        $stmt->execute([$packageId]);
        return $stmt->fetch() ?: ['subscribers' => 0, 'total_messages_used' => 0];
    }
}
