<?php

namespace App\Models;

class RouteSetting extends BaseModel
{
    protected string $table = 'route_settings';
    
    protected array $fillable = [
        'route_name', 'is_enabled', 'cost_per_message', 'priority', 'settings'
    ];
    
    public function getRoute(string $routeName): ?array
    {
        return $this->findBy('route_name', $routeName);
    }
    
    public function isRouteEnabled(string $routeName): bool
    {
        $route = $this->getRoute($routeName);
        return $route && $route['is_enabled'];
    }
    
    public function getEnabledRoutes(): array
    {
        $stmt = $this->db->prepare(
            "SELECT * FROM {$this->table} WHERE is_enabled = 1 ORDER BY priority ASC"
        );
        $stmt->execute();
        return $stmt->fetchAll();
    }
    
    public function getAllRoutes(): array
    {
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} ORDER BY priority ASC");
        $stmt->execute();
        return $stmt->fetchAll();
    }
    
    public function enableRoute(string $routeName): bool
    {
        $route = $this->getRoute($routeName);
        if ($route) {
            return $this->update($route['id'], ['is_enabled' => 1]);
        }
        return false;
    }
    
    public function disableRoute(string $routeName): bool
    {
        $route = $this->getRoute($routeName);
        if ($route) {
            return $this->update($route['id'], ['is_enabled' => 0]);
        }
        return false;
    }
    
    public function updateRouteCost(string $routeName, float $cost): bool
    {
        $route = $this->getRoute($routeName);
        if ($route) {
            return $this->update($route['id'], ['cost_per_message' => $cost]);
        }
        return false;
    }
    
    public function getRouteCost(string $routeName): float
    {
        $route = $this->getRoute($routeName);
        return $route ? (float)$route['cost_per_message'] : 0.0;
    }
    
    public function getPreferredRoute(): ?array
    {
        $routes = $this->getEnabledRoutes();
        return $routes[0] ?? null;
    }
}
