<?php

namespace App\Utils;

class Response
{
    public static function json($data, int $statusCode = 200): void
    {
        http_response_code($statusCode);
        header('Content-Type: application/json');
        echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit;
    }
    
    public static function success($data = null, string $message = 'Success', int $statusCode = 200): void
    {
        self::json([
            'success' => true,
            'message' => $message,
            'data' => $data
        ], $statusCode);
    }
    
    public static function error(string $message, int $statusCode = 400, $errors = null): void
    {
        $response = [
            'success' => false,
            'error' => $message
        ];
        
        if ($errors !== null) {
            $response['errors'] = $errors;
        }
        
        self::json($response, $statusCode);
    }
    
    public static function unauthorized(string $message = 'Unauthorized'): void
    {
        self::error($message, 401);
    }
    
    public static function forbidden(string $message = 'Forbidden'): void
    {
        self::error($message, 403);
    }
    
    public static function notFound(string $message = 'Not found'): void
    {
        self::error($message, 404);
    }
    
    public static function validationError(array $errors): void
    {
        self::error('Validation failed', 422, $errors);
    }
    
    public static function serverError(string $message = 'Internal server error'): void
    {
        self::error($message, 500);
    }
    
    public static function quotaExceeded(): void
    {
        self::error('Quota exceeded', 429);
    }
    
    public static function rateLimited(): void
    {
        self::error('Rate limit exceeded. Please try again later.', 429);
    }
}
