<?php

namespace App\Config;

class App
{
    public static function get(string $key, $default = null)
    {
        return $_ENV[$key] ?? $default;
    }
    
    public static function isDebug(): bool
    {
        return filter_var($_ENV['APP_DEBUG'] ?? false, FILTER_VALIDATE_BOOLEAN);
    }
    
    public static function getUrl(): string
    {
        return rtrim($_ENV['APP_URL'] ?? 'http://localhost', '/');
    }
    
    public static function getGatewayUrl(): string
    {
        return rtrim($_ENV['GATEWAY_URL'] ?? 'http://localhost:3000', '/');
    }
    
    public static function getJwtSecret(): string
    {
        return $_ENV['JWT_SECRET'] ?? 'default-secret-change-me';
    }
    
    public static function getJwtExpiry(): int
    {
        return (int)($_ENV['JWT_EXPIRY'] ?? 86400);
    }
    
    public static function getGatewaySecret(): string
    {
        return $_ENV['GATEWAY_SECRET'] ?? 'gateway-secret';
    }
}
