# Admin Manual

## Overview

This manual covers the administration of the WhatsApp Gateway SaaS platform. As an administrator, you have access to user management, package configuration, route management, and system monitoring.

---

## Accessing Admin Panel

1. Log in with an admin account
2. Click **Admin Panel** in the sidebar
3. You'll see the admin dashboard with system overview

**Default Admin Credentials:**
- Email: `admin@example.com`
- Password: `admin123`

> ⚠️ **Important:** Change the default password immediately after first login!

---

## Dashboard Overview

The admin dashboard displays:

- **Total Users** - All registered users
- **Active Users** - Users with active status
- **Active Subscriptions** - Current paid subscriptions
- **Connected Numbers** - WhatsApp numbers currently connected
- **Today's Messages** - Messages sent/received today
- **Monthly Revenue** - Estimated revenue this month
- **Channel Distribution** - Meta vs Baileys usage
- **Top Users** - Most active users by message count

---

## User Management

### Viewing Users

Navigate to **Admin > Users** to see all registered users.

**Filters:**
- **Role** - Filter by client, admin, or superadmin
- **Status** - Filter by active, suspended, or banned

### User Actions

| Action | Description |
|--------|-------------|
| **View** | See user details, subscription, and WhatsApp numbers |
| **Suspend** | Temporarily disable user access |
| **Ban** | Permanently disable user access |
| **Activate** | Re-enable a suspended/banned user |
| **Reset Password** | Generate a new password for the user |

### Creating Users

1. Click **Add User**
2. Fill in name, email, and role
3. A random password will be generated
4. Share the password with the user securely

### Disconnecting User's WhatsApp

If a user's WhatsApp session needs to be forcefully disconnected:

1. View the user's details
2. Find the WhatsApp number
3. Click **Disconnect**

This will:
- End the Baileys session
- Clear session files
- Mark the number as disconnected

---

## Package Management

### Default Packages

The system comes with four default packages:

| Package | Price | Messages | Numbers | Meta | Baileys |
|---------|-------|----------|---------|------|---------|
| Free | $0 | 100 | 1 | ❌ | ✅ |
| Starter | $29 | 1,000 | 2 | ✅ | ✅ |
| Business | $99 | 5,000 | 5 | ✅ | ✅ |
| Enterprise | $299 | 50,000 | 20 | ✅ | ✅ |

### Creating a Package

1. Go to **Admin > Packages**
2. Click **Add Package**
3. Configure:
   - **Name** - Display name
   - **Slug** - URL-friendly identifier (unique)
   - **Description** - Package description
   - **Monthly/Yearly Price** - Pricing
   - **Messages Limit** - Monthly message quota
   - **WhatsApp Numbers** - Max numbers allowed
   - **Projects per Number** - Max projects per number
   - **API Rate Limit** - Requests per minute
   - **Meta API Enabled** - Allow Meta Cloud API
   - **Baileys Enabled** - Allow Baileys engine

### Setting Default Package

New users automatically receive the default package. To change:

1. Find the package
2. Click the star icon to set as default

### Package Considerations

- Cannot delete packages with active subscribers
- Cannot delete the default package
- Price changes don't affect existing subscriptions

---

## Route Management

Routes control which messaging channels are available.

### Available Routes

| Route | Description |
|-------|-------------|
| **Meta** | Official Meta Cloud API (paid per message) |
| **Baileys** | Headless WhatsApp Web (credit-based) |

### Enabling/Disabling Routes

1. Go to **Admin > Routes**
2. Toggle the switch to enable/disable

**Important:** At least one route must be enabled for messaging to work.

### Route Configuration

**Cost per Message:**
- Set the cost charged to users per message
- Meta typically costs more than Baileys

**Priority:**
- Lower number = higher priority
- When hybrid mode is used, higher priority route is preferred

### Routing Logic

```
1. Check client's channel preference (meta/baileys/hybrid)
2. Check if preferred channel is enabled
3. Check if client's package allows the channel
4. Route to available channel
5. If hybrid, use priority to decide
```

---

## System Logs

### Viewing Logs

Navigate to **Admin > Logs** to see audit logs.

**Filters:**
- **Action** - Filter by action type
- **Entity Type** - Filter by entity (user, project, etc.)
- **Date Range** - Filter by time period

### Log Types

| Action | Description |
|--------|-------------|
| `user.registered` | New user registration |
| `user.login` | User login |
| `user.google_login` | Google OAuth login |
| `project.created` | New project created |
| `api_key.created` | New API key generated |
| `whatsapp_number.connected` | WhatsApp connected |
| `admin.user.suspended` | Admin suspended a user |
| `admin.package.updated` | Package settings changed |

### Log Details

Click **View** on any log to see:
- Old values (before change)
- New values (after change)
- User agent
- IP address

---

## Monitoring

### Key Metrics to Watch

1. **Failed Messages** - High failure rate indicates issues
2. **Disconnected Numbers** - May need reconnection
3. **Quota Exceeded Errors** - Users hitting limits
4. **Webhook Failures** - Client webhook issues

### Health Checks

**Gateway Service:**
```bash
curl http://localhost:3000/health
```

**Database:**
```sql
SELECT COUNT(*) FROM users;
SELECT COUNT(*) FROM messages WHERE DATE(created_at) = CURDATE();
```

### Common Issues

#### High Message Failure Rate

1. Check if WhatsApp numbers are connected
2. Verify Meta API tokens are valid
3. Check rate limiting isn't too aggressive

#### Users Can't Connect WhatsApp

1. Verify Gateway service is running
2. Check sessions folder permissions
3. Clear old session files if corrupted

#### Webhook Delivery Failures

1. Check client webhook URLs are accessible
2. Verify webhook secrets match
3. Review webhook logs for error details

---

## Security Best Practices

### Regular Tasks

- [ ] Review audit logs weekly
- [ ] Check for suspicious login patterns
- [ ] Monitor API usage for abuse
- [ ] Update admin passwords quarterly
- [ ] Review and clean old sessions

### Suspicious Activity Indicators

- Multiple failed login attempts
- Unusual message volumes
- API calls from unexpected IPs
- Rapid account creation

### Response Actions

1. **Suspend** the user immediately
2. **Review** their activity logs
3. **Ban** if confirmed malicious
4. **Report** to relevant authorities if needed

---

## Backup Procedures

### Daily Backups

```bash
# Database
mysqldump -u root -p whatsapp_gateway > backup_$(date +%Y%m%d).sql

# Sessions
tar -czf sessions_$(date +%Y%m%d).tar.gz gateway/sessions/
```

### Restore Procedures

```bash
# Database
mysql -u root -p whatsapp_gateway < backup_20240115.sql

# Sessions
tar -xzf sessions_20240115.tar.gz -C gateway/
```

---

## Support Escalation

### Level 1 - Self-Service

- Password resets
- Package upgrades
- Webhook configuration

### Level 2 - Admin Support

- Account suspensions
- Billing disputes
- Technical issues

### Level 3 - Developer Support

- System bugs
- Integration issues
- Custom development

---

## Glossary

| Term | Definition |
|------|------------|
| **Baileys** | Unofficial WhatsApp Web library for headless operation |
| **Meta Cloud API** | Official WhatsApp Business API by Meta |
| **Hybrid** | Mode that can use either Meta or Baileys |
| **Webhook** | HTTP callback for real-time notifications |
| **QR Code** | Used to authenticate Baileys sessions |
| **Session** | Authenticated WhatsApp connection state |
