const { v4: uuidv4 } = require('uuid');
const crypto = require('crypto');

function generateUuid() {
    return uuidv4();
}

function generateToken(length = 32) {
    return crypto.randomBytes(length).toString('hex');
}

function normalizePhoneNumber(phone) {
    let normalized = phone.replace(/[^0-9+]/g, '');
    if (!normalized.startsWith('+')) {
        normalized = '+' + normalized;
    }
    return normalized;
}

function formatPhoneForWhatsapp(phone) {
    let normalized = phone.replace(/[^0-9]/g, '');
    return normalized + '@s.whatsapp.net';
}

function extractPhoneFromJid(jid) {
    if (!jid) return null;
    const match = jid.match(/^(\d+)@/);
    return match ? '+' + match[1] : null;
}

function generateHmacSignature(payload, secret) {
    return crypto.createHmac('sha256', secret).update(payload).digest('hex');
}

function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

function isValidUrl(string) {
    try {
        new URL(string);
        return true;
    } catch (_) {
        return false;
    }
}

function getMessageType(message) {
    if (message.conversation || message.extendedTextMessage) return 'text';
    if (message.imageMessage) return 'image';
    if (message.videoMessage) return 'video';
    if (message.audioMessage) return 'audio';
    if (message.documentMessage) return 'document';
    if (message.stickerMessage) return 'sticker';
    if (message.locationMessage) return 'location';
    if (message.contactMessage || message.contactsArrayMessage) return 'contact';
    return 'unknown';
}

function extractMessageContent(message) {
    if (message.conversation) return message.conversation;
    if (message.extendedTextMessage?.text) return message.extendedTextMessage.text;
    if (message.imageMessage?.caption) return message.imageMessage.caption;
    if (message.videoMessage?.caption) return message.videoMessage.caption;
    if (message.documentMessage?.caption) return message.documentMessage.caption;
    return null;
}

module.exports = {
    generateUuid,
    generateToken,
    normalizePhoneNumber,
    formatPhoneForWhatsapp,
    extractPhoneFromJid,
    generateHmacSignature,
    sleep,
    isValidUrl,
    getMessageType,
    extractMessageContent
};
